
in vec2 texcoord;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

uniform bool worldTimeChanged;

layout(location = 0) out vec4 indirectData;
#if defined IS_OVERWORLD
	layout(location = 1) out vec4 skyboxData;
	/* DRAWBUFFERS:01 */

	#if TEMPORAL_UPSCALING == 2
		const ivec2[4] checkerboardOffset = ivec2[4](
			ivec2(0, 0), ivec2(1, 1),
			ivec2(1, 0), ivec2(0, 1)
		);
	#elif TEMPORAL_UPSCALING == 3
		const ivec2[9] checkerboardOffset = ivec2[9](
			ivec2(0, 0), ivec2(2, 0), ivec2(0, 2),
			ivec2(2, 2), ivec2(1, 1), ivec2(1, 0),
			ivec2(1, 2), ivec2(0, 1), ivec2(2, 1)
		);
	#elif TEMPORAL_UPSCALING == 4
		const ivec2[16] checkerboardOffset = ivec2[16](
			ivec2(0, 0), ivec2(2, 0), ivec2(0, 2), ivec2(2, 2),
			ivec2(1, 1), ivec2(3, 1), ivec2(1, 3), ivec2(3, 3),
			ivec2(1, 0), ivec2(3, 0), ivec2(1, 2), ivec2(3, 2),
			ivec2(0, 1), ivec2(2, 1), ivec2(0, 3), ivec2(2, 3)
		);
	#endif

	vec4 textureCatmullRom(in sampler2D tex, in vec2 coord) {
		vec2 res = textureSize(tex, 0);
		vec2 screenPixelSize = 1.0 / res;

		vec2 position = coord * res;
		vec2 centerPosition = floor(position - 0.5) + 0.5;

		vec2 f = position - centerPosition;

		vec2 w0 = f * (-0.5 + f * (1.0 - 0.5 * f));
		vec2 w1 = 1.0 + f * f * (-2.5 + 1.5 * f);
		vec2 w2 = f * (0.5 + f * (2.0 - 1.5 * f));
		vec2 w3 = f * f * (-0.5 + 0.5 * f);

		vec2 w12 = w1 + w2;

		vec2 tc0 = screenPixelSize * (centerPosition - 1.0);
		vec2 tc3 = screenPixelSize * (centerPosition + 2.0);
		vec2 tc12 = screenPixelSize * (centerPosition + w2 * rcp(w12));

		vec4 color = vec4(0.0);
		color += textureLod(tex, vec2(tc0.x, tc0.y), 0) * w0.x * w0.y;
		color += textureLod(tex, vec2(tc12.x, tc0.y), 0) * w12.x * w0.y;
		color += textureLod(tex, vec2(tc3.x, tc0.y), 0) * w3.x * w0.y;

		color += textureLod(tex, vec2(tc0.x, tc12.y), 0) * w0.x * w12.y;
		color += textureLod(tex, vec2(tc12.x, tc12.y), 0) * w12.x * w12.y;
		color += textureLod(tex, vec2(tc3.x, tc12.y), 0) * w3.x * w12.y;

		color += textureLod(tex, vec2(tc0.x, tc3.y), 0) * w0.x * w3.y;
		color += textureLod(tex, vec2(tc12.x, tc3.y), 0) * w12.x * w3.y;
		color += textureLod(tex, vec2(tc3.x, tc3.y), 0) * w3.x * w3.y;

		return color;
	}
#else
	/* DRAWBUFFERS:0 */
#endif

#include "/lib/Head/Functions.inc"

#ifdef SSAO_ENABLED
	#include "/lib/Lighting/AmbientOcclusion.glsl"
#endif

#ifdef GI_ENABLED
	#include "/lib/Lighting/GlobalIllumination.glsl"
#endif

vec3 Reproject(in vec3 screenPos) {
    vec3 projection = screenPos * 2.0 - 1.0;
    projection = (vec3(vec2(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y) * projection.xy, 0.0) + gbufferProjectionInverse[3].xyz) / (gbufferProjectionInverse[2].w * projection.z + gbufferProjectionInverse[3].w);
    projection = mat3(gbufferPreviousModelView) * (mat3(gbufferModelViewInverse) * projection + gbufferModelViewInverse[3].xyz + cameraPosition - previousCameraPosition) + gbufferPreviousModelView[3].xyz;
    projection = (vec3(gbufferPreviousProjection[0].x, gbufferPreviousProjection[1].y, gbufferPreviousProjection[2].z) * projection + gbufferPreviousProjection[3].xyz) / -projection.z * 0.5 + 0.5;
    return projection;
}

vec4 TemporalLightAccumulation() {
	if (min(texcoord, 0.5) == texcoord) {
		ivec2 texel = ivec2(gl_FragCoord.xy) * 2;
		float depth = texelFetch(depthtex0, texel, 0).x;
		if (depth >= 1.0) return vec4(0.0);

		vec3 normal = GetNormals(texel);
		vec3 worldNormal = mat3(gbufferModelViewInverse) * normal;

		//float dither = R1(frameCounter, texelFetch(noisetex, ivec2(gl_FragCoord.xy / 0.5) & 255, 0).a);
		float dither = RandNextF();
		// float dither = texelFetch(noisetex, texel & 255, 0).a;
		// dither = fract(dither + frameCounter * rPI);

		vec4 currLight = vec4(vec3(0.0), 1.0);
		vec2 coord = texcoord * 2.0;

		//vec2 velocity = (depth < 0.56) ? vec2(0.0) : CalculateCameraVelocity(coord, depth);

		//depth += 0.38 * step(depth, 0.56);
		vec3 screenPos = vec3(coord, depth);
		vec3 viewPos = ScreenToViewSpace(screenPos);

		#ifdef SSAO_ENABLED
			if (depth > 0.56) currLight.a = GetDSSAO(worldNormal, depth, coord, dither);
			// if (depth > 0.56) currLight.a = GetSSAO(viewPos, normal, dither);
		#endif

		#ifdef GI_ENABLED
			currLight.rgb = CalculateRSM(viewPos, worldNormal, dither);
		#endif

		vec2 prevCoord = (depth < 0.56) ? coord : Reproject(screenPos).xy;
		if (clamp(prevCoord, screenPixelSize, 1.0 - screenPixelSize) != prevCoord || worldTimeChanged) return currLight;

		prevCoord *= 0.5;

		vec4 prevData = texture(colortex0, prevCoord + vec2(0.5, 0.0));

		float currDist = -viewPos.z;

		//float NdotV = saturate(dot(worldNormal, -normalize(mat3(gbufferModelViewInverse) * viewPos)));

		float cameraMovement = distance(cameraPosition, previousCameraPosition);

		float frameIndex = min(texture(colortex0, prevCoord + 0.5).x, 32.0);
		frameIndex *= step((distance(currDist, prevData.a) - cameraMovement) / abs(currDist), 0.1);
		frameIndex *= step(0.5, dot(normal, prevData.xyz));

		vec4 blendWeight = vec4(frameIndex) * rcp(frameIndex + 1.0);
		blendWeight.w *= 0.6;

		vec4 prevLight = texture(colortex0, prevCoord);

		return clamp16F(mix(currLight, prevLight, blendWeight));
		// return clamp16F(mix(currLight, prevLight, 0.95 * weight));
	} else if (texcoord.y < 0.5) {
		ivec2 texel = ivec2(gl_FragCoord.xy) * 2 - ivec2(viewWidth, 0);
		float depth = GetDepthT(texel);
		if (depth >= 1.0) return vec4(vec3(0.5), 0.0);
		//depth += 0.38 * step(depth, 0.56);

		vec3 normal = GetNormals(texel);
		float dist = ScreenToViewSpace(depth);

		return vec4(normal, dist);
	}

	//return texelFetch(colortex0, ivec2(gl_FragCoord.xy), 0);
}

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	#if defined GI_ENABLED || defined SSAO_ENABLED
		indirectData = TemporalLightAccumulation();
	#else
		indirectData = vec4(vec3(0.0), 1.0);
	#endif

	#if defined IS_OVERWORLD
		ivec2 texel = ivec2(gl_FragCoord.xy);

		vec2 previousCoord = Reproject(vec3(texcoord, 1.0)).xy;
		vec2 historyData = max0(texture(colortex0, previousCoord * 0.5 + 0.5).xy);

		if (all(greaterThanEqual(texcoord, vec2(0.5)))) {
			indirectData.x = historyData.x + 1.0; 					// Store frame index
			indirectData.y = 1.0 - GetDepthT(texcoord * 2.0 - 1.0); // Store reversed depth
		}

		if (saturate(previousCoord) != previousCoord
		 || GetDepthT(texel) == 1.0 && historyData.y > 1e-6
		 || worldTimeChanged || historyData.x < 0.5) {
			skyboxData = textureBicubic(colortex2, min(texcoord * rcp(float(TEMPORAL_UPSCALING)), rcp(TEMPORAL_UPSCALING) - screenPixelSize));
			return;
		}

		const int cloudsRenderFactor = TEMPORAL_UPSCALING * TEMPORAL_UPSCALING;

		ivec2 offset = checkerboardOffset[frameCounter % cloudsRenderFactor];

		// float pixelDistance = dotSelf(offset) * TEMPORAL_UPSCALING;
		// float confidence    = expf(-pixelDistance * 0.025 * exp2(2.*historyData.x));
		
		// float finalBlend = saturate(historyData.x / (++historyData.x));
		// finalBlend *= confidence;

		float cameraMovement = expf(-16.0 * distance(cameraPosition, previousCameraPosition));
		historyData.x = min(historyData.x, MAX_BLENDED_FRAMES);
		float blendWeight = 1.0 - rcp(max(historyData.x - cloudsRenderFactor, 1.0));
		blendWeight *= mix(1.0, cameraMovement, blendWeight);
		vec2 pixelVelocity = 1.0 - abs(fract(previousCoord * screenSize) * 2.0 - 1.0);
		blendWeight *= sqrt(pixelVelocity.x * pixelVelocity.y) * 0.75 + 0.25;
		blendWeight *= mix(1.0, sqrt(pixelVelocity.x * pixelVelocity.y), blendWeight);

		vec4 prevData = clamp16F(textureCatmullRom(colortex1, previousCoord));
		//prevData.rgb = SRGBtoLinear(prevData.rgb) * 1e4;
		if (offset == texel % TEMPORAL_UPSCALING) {
			skyboxData = texelFetch(colortex2, clamp(texel / TEMPORAL_UPSCALING, ivec2(0), ivec2(screenSize) / TEMPORAL_UPSCALING - 1), 0);
			skyboxData = mix(skyboxData, prevData, blendWeight);
		//} else skyboxData = mix(textureBicubicLod(colortex1, previousCoord, TEMPORAL_UPSCALING - 1), prevData, saturate(historyData.x / (++historyData.x)));
		} else skyboxData = prevData;

		// // Scale constants
		// vec4 scale = vec4(
		// 	1. / vec2(textureSize(colortex2, 0)),
		// 	vec2(textureSize(colortex2, 0)) * screenPixelSize
		// );

		// // Source position in fractions of a texel
		// vec2 src_pos = scale.zw * gl_FragCoord.xy;
		// // Source bottom left texel centre
		// vec2 src_centre = floor(src_pos - .5) + .5;
		// // f is position. f.x runs left to right, y bottom to top, z right to left, w top to bottom
		// vec4 f; f.zw = 1. - (f.xy = src_pos - src_centre);
		// // Calculate weights in x and y in parallel.
		// // These polynomials are piecewise approximation of Lanczos kernel
		// // Calculator here: https://gist.github.com/going-digital/752271db735a07da7617079482394543
		// vec4 l2_w0_o3 = ((1.5672 * f - 2.6445) * f + 0.0837) * f + 0.9976;
		// vec4 l2_w1_o3 = ((-0.7389 * f + 1.3652) * f - 0.6295) * f - 0.0004;

		// vec4 w1_2 = l2_w0_o3;
		// vec2 w12 = w1_2.xy + w1_2.zw;
		// vec4 wedge = l2_w1_o3.xyzw * w12.yxyx;
		// // Calculate texture read positions. tc12 uses bilinear interpolation to do 4 reads in 1.
		// vec2 tc12 = scale.xy * (src_centre + w1_2.zw / w12);
		// vec2 tc0 = scale.xy * (src_centre - 1.);
		// vec2 tc3 = scale.xy * (src_centre + 2.);
		// // Sharpening adjustment
		// // Thanks mad_gooze for the normalization fix.
		// float sum = wedge.x + wedge.y + wedge.z + wedge.w + w12.x * w12.y;    
		// wedge /= sum;
		// vec4 col = vec4(
		// 	texture(colortex2, vec2(tc12.x, tc0.y) / TEMPORAL_UPSCALING) * wedge.y +
		// 	texture(colortex2, vec2(tc0.x, tc12.y) / TEMPORAL_UPSCALING) * wedge.x +
		// 	texture(colortex2, tc12.xy / TEMPORAL_UPSCALING) * (w12.x * w12.y) +
		// 	texture(colortex2, vec2(tc3.x, tc12.y) / TEMPORAL_UPSCALING) * wedge.z +
		// 	texture(colortex2, vec2(tc12.x, tc3.y) / TEMPORAL_UPSCALING) * wedge.w
		// );

		// skyboxData = col;
	#endif
}
